@echo off
setlocal

:Setup
REM %1, %2, %3, %4 represent arugments given to the batch file. 
REM CALL Shinydocs-PII.bat <IndexName> <IndexURL> <CognitiveToolkitExecutable> <C-ScriptFilePath>
REM eg. CALL Shinydocs-PII.bat shinyindex http://localhost:9200 D:\Shinydocs\CognitiveToolkit\CognitiveToolkit.exe D:\Shinydocs\scripts\Runscript\flagfieldbasedonregexscript.cs
SET IndexName=%1
SET IndexURL=%2
SET CognitiveToolkitExecutable=%3
SET C-ScriptFilePath=%4
SET Threads=4
SET NPR=5000

:RunScript Setup
SET WorkingDir=%~dp0

echo Candian SIN Number
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\canadian-SIN.json" --regex-pattern "\b[1-79]\d{2}[ -]{0,3}\d{3}[ -]{0,3}\d{3}\b" --field-name "potential_PII" --value "Canadian Social Insurance Number" --search-field fullText --valid-luhn true
echo Ontario Health Card
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\canadian-health-card.json" --regex-pattern "\b[1-9]\d{3}[ -]{0,3}\d{3}[ -]{0,3}\d{3}[ -]{0,3}[a-zA-Z]{2}\b" --field-name "potential_PII" --value "Canadian Health Card Number" --search-field fullText
echo Ontario Driver License
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\canadian-drivers-license.json" --regex-pattern "\b[a-zA-Z]\d{4}[ -]{0,3}\d{5}[ -]{0,3}\d[0156]\d[0-3]\d\b" --field-name "potential_PII" --value "Canadian Drivers License Number" --search-field fullText
echo Canadian Passport Number
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\canadian-passport-number.json" --regex-pattern "\b[a-zA-Z]{2}[0-9]{6,7}\b" --field-name "potential_PII" --value "Canadian Passport Number" --search-field fullText
echo Candian Postal Code
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\canadian-postal-code.json" --regex-pattern "\b[a-zA-Z]\d[a-zA-Z][ -]{0,3}\d[a-zA-Z]\d\b" --field-name "potential_PII" --value "Canadian Postal Code" --search-field fullText
echo AMEX
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\creditcard.json" --regex-pattern "\b(3[47]\d{2}[ -]{0,3}\d{6}[ -]{0,3}\d{5})\b" --field-name "potential_PII" --value "Credit Card AMEX" --search-field fullText --valid-luhn true
echo Mastercard
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\creditcard.json" --regex-pattern "\b(5[1-5]\d{2}|222[1-9]|22[3-9]\d|2[3-6]\d{2}|27[01]\d|2720)[ -]{0,3}\d{4}[ -]{0,3}\d{4}[ -]{0,3}\d{4}\b" --field-name "potential_PII" --value "Credit Card Mastercard" --search-field fullText --valid-luhn true
echo Visa
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\creditcard.json" --regex-pattern "\b((4\d{3}[ -]{0,3}\d{4}[ -]{0,3}\d{4}[ -]{0,3}\d{4})|(4\d{3}[ -]{0,3}\d{3}[ -]{0,3}\d{3}[ -]{0,3}\d{3}))\b" --field-name "potential_PII" --value "Credit Card Visa" --search-field fullText --valid-luhn true
echo USA Social Security Number (Formatted)
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\SSN.json" --regex-pattern "(?is)(\b(?!666|000|9\d{2})\d{3} ?[\u002D\u007E\u00AD\u2010\u2011\u2012\u2013\u2212] ?(?!00)\d{2} ?[\u002D\u007E\u00AD\u2010\u2011\u2012\u2013\u2212] ?(?!0{4})\d{4}\b)" --field-name "potential_PII" --value "USA Social Security Number (Formatted)" --search-field fullText
echo USA Social Security Number (Proximity)
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\SSN.json" --regex-pattern "(?is)((\b(Social Security|Social Security#|Soc Sec|SSN|SSNS|SSN#|SS#|SSID|Soc. Sec. No|tax(payer)? identification number|Tax ID Number)(?!\w).{0,300}\b((?!666|000|9\d{2})\d{3} ?(?!00)\d{2} ?(?!0{4})\d{4})\b)|(\b((?!666|000|9\d{2})\d{3} ?(?!00)\d{2}(?!0{4}) ?\d{4})\b.{0,300}\b(Social Security|Social Security#|Soc Sec|SSN|SSNS|SSN#|SS#|SSID|Soc. Sec. No|tax(payer)? identification number|Tax ID Number)(?!\w)))" --field-name "potential_PII" --value "USA Social Security Number (Proximity)" --search-field fullText
echo USA Passport Number
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\passport-number.json" --regex-pattern "(?is)(\b(passport\s*(book|card)?\s*number|Passport.{1,150}Document Number|Passport.{1,150}Department of State|Passport No|Passport #|Passport[#:]|PassportID|Passportno|passportnumber|パスポート|パスポート番号|パスポートのNum|パスポート＃|Numéro de passeport|Passeport n °|Passeport Non|Passeport #|Passeport#|PasseportNon|Passeportn °|Pasaporte)(?!\w).{0,500}\b[a-zA-Z0-9]\d{8}\b)|(\b[a-zA-Z0-9]\d{8}\b.{0,500}\b(passport\s*(book|card)?\s*number|Passport.{1,150}Document Number|Passport.{1,150}Department of State|Passport No|Passport #|Passport[#:]|PassportID|Passportno|passportnumber|パスポート|パスポート番号|パスポートのNum|パスポート＃|Numéro de passeport|Passeport n °|Passeport Non|Passeport #|Passeport#|PasseportNon|Passeportn °|Pasaporte)(?!\w))" --field-name "potential_PII" --value "USA Passport Number" --search-field fullText
echo Medicare
%CognitiveToolkitExecutable% RunScript --path %C-ScriptFilePath% -i %IndexName% -u %IndexURL% --threads %Threads% --nodes-per-request %NPR% -q "%WorkingDir%pii-queries\medicare.json" --regex-pattern "(?i)\b(([1-9][AC-HJKMNP-RT-Y]{2}[0-9]-[AC-HJKMNP-RT-Y][AC-HJKMNP-RT-Y0-9][0-9]-[AC-HJKMNP-RT-Y]{2}[0-9]{2})|([1-9][AC-HJKMNP-RT-Y]{2}[0-9][AC-HJKMNP-RT-Y][AC-HJKMNP-RT-Y0-9][0-9][AC-HJKMNP-RT-Y]{2}[0-9]{2}))\b" --field-name "potential_PII" --value "Medicare Number" --search-field fullText
echo Complete
